/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.logic;

import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.ContentRegistry;
import ejektaflex.bountiful.api.enum.EnumBountyRarity;
import ejektaflex.bountiful.api.ext.ExtMiscKt;
import ejektaflex.bountiful.api.logic.IBountyCreator;
import ejektaflex.bountiful.api.logic.IPickCommon;
import ejektaflex.bountiful.api.logic.ItemRange;
import ejektaflex.bountiful.api.logic.pickable.PickableEntry;
import ejektaflex.bountiful.api.logic.picked.IPickedEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntryStack;
import ejektaflex.bountiful.data.BountyData;
import ejektaflex.bountiful.item.ItemBounty;
import ejektaflex.bountiful.logic.error.BountyCreationException;
import ejektaflex.bountiful.registry.BountyRegistry;
import ejektaflex.bountiful.registry.RewardRegistry;
import ejektaflex.bountiful.registry.ValueRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lejektaflex/bountiful/logic/BountyCreator;", "Lejektaflex/bountiful/api/logic/IBountyCreator;", "()V", "rand", "Ljava/util/Random;", "calcRarity", "Lejektaflex/bountiful/api/enum/EnumBountyRarity;", "create", "Lejektaflex/bountiful/data/BountyData;", "world", "Lnet/minecraft/world/World;", "inRarity", "createPremadeBounty", "createRandomBounty", "createStack", "Lnet/minecraft/item/ItemStack;", "rarity", "findRewards", "", "Lejektaflex/bountiful/api/logic/picked/PickedEntryStack;", "n", "", "precheckRegistries", "", "Bountiful"})
public final class BountyCreator
implements IBountyCreator {
    private static final java.util.Random rand;
    public static final BountyCreator INSTANCE;

    @Override
    @NotNull
    public ItemStack createStack(@NotNull World world, @Nullable EnumBountyRarity rarity) {
        ItemStack itemStack;
        ItemBounty itemBounty;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        ItemBounty it = itemBounty = ContentRegistry.INSTANCE.getBounty();
        ItemStack $receiver = itemStack = new ItemStack((Item)it);
        it.ensureBounty($receiver, world, rarity);
        return itemStack;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EnumBountyRarity calcRarity() {
        int level = 0;
        double chance = Bountiful.INSTANCE.getConfig().getRarityChance();
        int n = 0;
        int n2 = 3;
        while (n < n2 && (double)rand.nextFloat() < chance) {
            void i;
            ++level;
            ++i;
        }
        return EnumBountyRarity.Companion.getRarityFromInt(level);
    }

    private final void precheckRegistries(World world) {
        if (RewardRegistry.INSTANCE.validRewards(world).isEmpty()) {
            throw (Throwable)new BountyCreationException("There are no valid rewards in the reward registry!");
        }
        if (BountyRegistry.INSTANCE.validBounties(world).size() < Bountiful.INSTANCE.getConfig().getBountyAmountRange().getLast()) {
            throw (Throwable)new BountyCreationException("There are not enough valid bounties in the bounty registry! (At least " + Bountiful.INSTANCE.getConfig().getBountyAmountRange() + " must be valid at any one time).");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BountyData createRandomBounty(World world, EnumBountyRarity inRarity) {
        IPickCommon it;
        this.precheckRegistries(world);
        List pickedAlready = new ArrayList();
        Object object = Bountiful.INSTANCE.getConfig().getBountyAmountRange();
        int toPick = RangesKt.random((IntRange)object, (Random)((Random)Random.Default));
        while (pickedAlready.size() < toPick) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)BountyRegistry.INSTANCE.validBounties(world);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (PickableEntry)element$iv$iv;
                if (!(!pickedAlready.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List pool = (List)destination$iv$iv;
            PickableEntry toAdd = (PickableEntry)ExtMiscKt.getWeightedRandom(pool);
            pickedAlready.add(PickableEntry.copy$default(toAdd, null, null, 0, 0, null, null, 63, null));
        }
        Object $receiver = object = new BountyData();
        EnumBountyRarity enumBountyRarity = inRarity;
        ((BountyData)$receiver).setRarity(enumBountyRarity != null ? enumBountyRarity.getLevel() : INSTANCE.calcRarity().getLevel());
        ((BountyData)$receiver).setWorth(0);
        double preBountyTime = 0.0;
        Iterable $receiver$iv = pickedAlready;
        for (Object element$iv : $receiver$iv) {
            it = (PickableEntry)element$iv;
            IPickedEntry picked = it.pick();
            if (picked.getContentObj() != null) {
                ((ValueRegistry)((BountyData)$receiver).getToGet()).add(picked);
                Object object2 = $receiver;
                ((BountyData)object2).setWorth(((BountyData)object2).getWorth() + picked.getAmount() * it.getUnitWorth());
                preBountyTime += (double)(picked.getAmount() * it.getUnitWorth()) * picked.timeMult();
                continue;
            }
            throw (Throwable)new BountyCreationException("You tried to create a bounty but the item was invalid! Item was: " + picked.getContent());
        }
        long l = (long)(preBountyTime * Bountiful.INSTANCE.getConfig().getTimeMultiplier());
        long l2 = Bountiful.INSTANCE.getConfig().getBountyTimeMin();
        Object object3 = $receiver;
        long l3 = Math.max(l, l2);
        ((BountyData)object3).setBountyTime(l3);
        ((BountyData)$receiver).setWorth((int)((double)((BountyData)$receiver).getWorth() * EnumBountyRarity.Companion.getRarityFromInt(((BountyData)$receiver).getRarity()).getBountyMult()));
        $receiver$iv = INSTANCE.findRewards(world, ((BountyData)$receiver).getWorth());
        for (Object element$iv : $receiver$iv) {
            it = (PickedEntryStack)element$iv;
            ((ValueRegistry)((BountyData)$receiver).getRewards()).add(it);
        }
        return object;
    }

    private final BountyData createPremadeBounty(EnumBountyRarity inRarity) {
        return new BountyData();
    }

    @Override
    @Nullable
    public BountyData create(@NotNull World world, @Nullable EnumBountyRarity inRarity) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        return Bountiful.INSTANCE.getConfig().getRandomBounties() ? this.createRandomBounty(world, inRarity) : this.createPremadeBounty(inRarity);
    }

    private final List<PickedEntryStack> findRewards(World world, int n) {
        Collection collection;
        int worthLeft = n;
        List toRet = new ArrayList();
        List picked = new ArrayList();
        List<PickedEntryStack> validRewards = RewardRegistry.INSTANCE.validRewards(world, worthLeft, picked);
        while (!(collection = (Collection)validRewards).isEmpty()) {
            int n2;
            int maxNumCouldGive;
            int n3;
            PickedEntryStack pickedEntryStack;
            boolean bl = Bountiful.INSTANCE.getConfig().getGreedyRewards();
            if (bl) {
                pickedEntryStack = (PickedEntryStack)CollectionsKt.last(validRewards);
            } else if (!bl) {
                pickedEntryStack = ExtMiscKt.getWeightedRandom(validRewards);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            PickedEntryStack reward = pickedEntryStack;
            int it = n3 = (maxNumCouldGive = worthLeft / reward.getAmount());
            ItemRange minMaxRange = reward.getGenericPick().getRange();
            if (minMaxRange != null) {
                if (!Bountiful.INSTANCE.getConfig().getTryMaxRewardQuantity()) {
                    if (minMaxRange.getMin() < minMaxRange.getMax() && minMaxRange.getMin() >= 0) {
                        ItemRange newRange = new ItemRange(minMaxRange.getMin(), minMaxRange.getMin() + world.field_73012_v.nextInt(minMaxRange.getMax() - minMaxRange.getMin()));
                        n2 = ExtMiscKt.clampTo(it, newRange.toIntRange());
                    } else {
                        n2 = ExtMiscKt.clampTo(it, minMaxRange.toIntRange());
                    }
                } else {
                    n2 = ExtMiscKt.clampTo(it, minMaxRange.toIntRange());
                }
            } else {
                n2 = it;
            }
            int numCanGive = n2;
            int worthSated = reward.getAmount() * numCanGive;
            worthLeft -= worthSated;
            NBTTagCompound nBTTagCompound = reward.getTag();
            PickedEntryStack rewardClone = new PickedEntryStack(new PickedEntry(reward.getContent(), numCanGive, 0, nBTTagCompound != null ? nBTTagCompound.toString() : null, reward.getStages(), null, 36, null));
            picked.add(rewardClone.getContent());
            toRet.add(rewardClone);
            validRewards = RewardRegistry.INSTANCE.validRewards(world, worthLeft, picked);
        }
        if (toRet.isEmpty()) {
            Object v3;
            Iterable $receiver$iv = RewardRegistry.INSTANCE.validRewards(world);
            Iterator iterator$iv = $receiver$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                PickedEntryStack it = (PickedEntryStack)minElem$iv;
                int minValue$iv = it.getAmount();
                while (iterator$iv.hasNext()) {
                    Object e$iv = iterator$iv.next();
                    PickedEntryStack it2 = (PickedEntryStack)e$iv;
                    int v$iv = it2.getAmount();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                }
                v3 = minElem$iv;
            }
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            PickedEntryStack lowestWorthItem = v3;
            ItemRange itemRange = lowestWorthItem.getGenericPick().getRange();
            NBTTagCompound nBTTagCompound = lowestWorthItem.getTag();
            toRet.add(new PickedEntryStack(new PickedEntry(lowestWorthItem.getContent(), itemRange != null ? itemRange.getMin() : 1, 0, nBTTagCompound != null ? nBTTagCompound.toString() : null, null, null, 52, null)));
        }
        return toRet;
    }

    private BountyCreator() {
    }

    static {
        BountyCreator bountyCreator;
        INSTANCE = bountyCreator = new BountyCreator();
        rand = new java.util.Random();
    }
}

